CREATE TABLE IF NOT EXISTS file_metadata (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    type TEXT,
    title TEXT,
    fields TEXT,
    created BIGINT,
    updated BIGINT,
    created_by VARCHAR(36)
);

CREATE INDEX idx_file_metadata_id ON file_metadata (id);

-- Insert data from metadata table
INSERT INTO file_metadata (
    id, type, title, fields, created, updated, 
    created_by
) 
SELECT 
    id, 
    type, 
    title, 
    fields, 
    created, 
    updated, 
    created_by 
FROM 
    metadata 
WHERE 
    app="Files";
