CREATE TABLE IF NOT EXISTS file_share (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    file_id VARCHAR(36) NOT NULL,
    parent VARCHAR(36) NOT NULL,
    initiator VARCHAR(255) NOT NULL,
    share_type INT(11) NOT NULL,
    share_with VARCHAR(36) NOT NULL,
    expiration VARCHAR(255),
    allow_reshare TINYINT(1) NOT NULL,
    allow_edit TINYINT(1) NOT NULL,
    allow_edit_meta TINYINT(1) NOT NULL,
    time_shared BIGINT(20) NOT NULL,
    created BIGINT(20) NOT NULL,
    CONSTRAINT unique_share UNIQUE (file_id,share_type,share_with)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_file_share_file_id ON file_share (file_id);

CREATE INDEX idx_file_share_share_with ON file_share (share_with);

CREATE INDEX idx_file_share_parent ON file_share (parent);

