CREATE TABLE IF NOT EXISTS external_share (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    owner VARCHAR(36) NOT NULL,
    file_id VARCHAR(36) NOT NULL,
    password_protected TINYINT(1),
    password VARCHAR(255) NOT NULL,
    source VARCHAR(255),
    parent VARCHAR(255),
    share_token VARCHAR(255) NOT NULL UNIQUE,
    share_time BIGINT(20),
    message LONGTEXT,
    expiration VARCHAR(255),
    allow_download TINYINT(1),
    allow_upload TINYINT(1),
    downloaded INT(11),
    accessed INT(11),
    active TINYINT(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_external_share_file_id ON external_share (file_id);

CREATE INDEX idx_external_share_token ON external_share (share_token);

CREATE INDEX idx_external_share_active ON external_share (active);

CREATE INDEX idx_external_share_source ON external_share (source);

CREATE INDEX idx_external_share_parent ON external_share (parent);

CREATE INDEX idx_external_share_owner ON external_share (owner);